/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.bukkit.configuration.files;

import java.io.File;
import me.nurio.bukkit.configuration.exceptions.ConfigFileOutsidePluginFolderException;
import me.nurio.bukkit.configuration.files.GrechConfigFile;
import me.nurio.bukkit.configuration.parsers.LocationConfigParser;
import me.nurio.bukkit.configuration.utils.FilePaths;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class GrechConfig
implements GrechConfigFile,
LocationConfigParser {
    @NotNull
    private Plugin plugin;
    @NotNull
    private File configFile;
    @NotNull
    private FileConfiguration config;

    public GrechConfig(@NotNull Plugin plugin, File file) {
        this.plugin = plugin;
        this.configFile = file;
        if (!FilePaths.isFileInDirectory(file, plugin.getDataFolder())) {
            throw new ConfigFileOutsidePluginFolderException(file, plugin);
        }
        this.saveDefaultConfig();
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public GrechConfig(@NotNull Plugin plugin, String filename) {
        this(plugin, new File(plugin.getDataFolder(), (String)(filename.endsWith(".yml") ? filename : filename + ".yml")));
    }

    public GrechConfig(String filename, @NotNull Plugin plugin) {
        this(plugin, filename);
    }

    public GrechConfig(File file, @NotNull Plugin plugin) {
        this(plugin, file);
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public File getConfigFile() {
        return this.configFile;
    }

    @Override
    @NotNull
    public FileConfiguration getConfig() {
        return this.config;
    }
}

