/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.bukkit.configuration.files;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public interface GrechConfigFile {
    @NotNull
    public Plugin getPlugin();

    @NotNull
    public FileConfiguration getConfig();

    @NotNull
    public File getConfigFile();

    default public void set(String path, Object value) {
        this.getConfig().set(path, value);
    }

    default public void save() {
        try {
            this.getConfig().save(this.getConfigFile());
        }
        catch (IOException ex) {
            System.err.println("Could not save config to " + this.getConfigFile().getName());
            System.err.println(ex.getMessage());
        }
    }

    default public void saveDefaultConfig() {
        if (this.fileExists()) {
            return;
        }
        if (this.existsDefaultConfig()) {
            this.getPlugin().saveResource(this.getConfigFile().getName(), false);
            return;
        }
        try {
            this.getConfigFile().getParentFile().mkdirs();
            this.getConfigFile().createNewFile();
        }
        catch (IOException e) {
            System.err.println("Error creating plugin config file!");
            System.err.println(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    default public boolean existsDefaultConfig() {
        InputStream in = this.getPlugin().getResource(this.getConfigFile().getName());
        return in != null;
    }

    default public boolean fileExists() {
        return this.getConfigFile().exists();
    }
}

