/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.bungeekeeper.packets.bungee;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetSocketAddress;
import lombok.NonNull;
import me.nurio.bungeekeeper.packets.IdentityUtil;
import me.nurio.bungeekeeper.packets.Packet;

public class HandshakePacket
implements Packet {
    public static final byte PACKET_ID = 20;
    private long eventId = IdentityUtil.timeBasedId();
    @NonNull
    private InetSocketAddress address;
    @NonNull
    private String domain;
    @NonNull
    private int port;
    @NonNull
    private int protocol;

    @Override
    public byte getId() {
        return 20;
    }

    @Override
    public void read(DataInputStream inputStream) {
        String inetAddress = inputStream.readUTF();
        int inetPort = inputStream.readInt();
        this.address = InetSocketAddress.createUnresolved(inetAddress, inetPort);
        this.domain = inputStream.readUTF();
        this.port = inputStream.readInt();
        this.protocol = inputStream.readInt();
    }

    @Override
    public void write(DataOutputStream outputStream) {
        outputStream.writeByte(20);
        outputStream.writeUTF(this.address.getHostName());
        outputStream.writeInt(this.address.getPort());
        outputStream.writeUTF(this.domain);
        outputStream.writeInt(this.port);
        outputStream.writeInt(this.protocol);
    }

    public long getEventId() {
        return this.eventId;
    }

    @NonNull
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @NonNull
    public String getDomain() {
        return this.domain;
    }

    @NonNull
    public int getPort() {
        return this.port;
    }

    @NonNull
    public int getProtocol() {
        return this.protocol;
    }

    public void setEventId(long eventId) {
        this.eventId = eventId;
    }

    public void setAddress(@NonNull InetSocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.address = address;
    }

    public void setDomain(@NonNull String domain) {
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        this.domain = domain;
    }

    public void setPort(@NonNull int port) {
        this.port = port;
    }

    public void setProtocol(@NonNull int protocol) {
        this.protocol = protocol;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HandshakePacket)) {
            return false;
        }
        HandshakePacket other = (HandshakePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEventId() != other.getEventId()) {
            return false;
        }
        InetSocketAddress this$address = this.getAddress();
        InetSocketAddress other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        return this.getProtocol() == other.getProtocol();
    }

    protected boolean canEqual(Object other) {
        return other instanceof HandshakePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $eventId = this.getEventId();
        result = result * 59 + (int)($eventId >>> 32 ^ $eventId);
        InetSocketAddress $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        result = result * 59 + this.getPort();
        result = result * 59 + this.getProtocol();
        return result;
    }

    public String toString() {
        return "HandshakePacket(eventId=" + this.getEventId() + ", address=" + this.getAddress() + ", domain=" + this.getDomain() + ", port=" + this.getPort() + ", protocol=" + this.getProtocol() + ")";
    }

    public HandshakePacket() {
    }

    public HandshakePacket(long eventId, @NonNull InetSocketAddress address, @NonNull String domain, @NonNull int port, @NonNull int protocol) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        this.eventId = eventId;
        this.address = address;
        this.domain = domain;
        this.port = port;
        this.protocol = protocol;
    }

    public HandshakePacket(@NonNull InetSocketAddress address, @NonNull String domain, @NonNull int port, @NonNull int protocol) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        this.address = address;
        this.domain = domain;
        this.port = port;
        this.protocol = protocol;
    }
}

