/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.bungeekeeper.packets.bungee;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetSocketAddress;
import java.util.UUID;
import lombok.NonNull;
import me.nurio.bungeekeeper.packets.IdentityUtil;
import me.nurio.bungeekeeper.packets.Packet;

public class PostConnectionPacket
implements Packet {
    public static final byte PACKET_ID = 22;
    private long eventId = IdentityUtil.timeBasedId();
    @NonNull
    private String username;
    @NonNull
    private UUID uuid;
    @NonNull
    private InetSocketAddress address;
    @NonNull
    private int protocol;

    @Override
    public byte getId() {
        return 22;
    }

    @Override
    public void read(DataInputStream inputStream) {
        this.username = inputStream.readUTF();
        this.uuid = UUID.fromString(inputStream.readUTF());
        String inetAddress = inputStream.readUTF();
        int inetPort = inputStream.readInt();
        this.address = InetSocketAddress.createUnresolved(inetAddress, inetPort);
        this.protocol = inputStream.readInt();
    }

    @Override
    public void write(DataOutputStream outputStream) {
        outputStream.writeByte(22);
        outputStream.writeUTF(this.username);
        outputStream.writeUTF(this.uuid.toString());
        outputStream.writeUTF(this.address.getHostName());
        outputStream.writeInt(this.address.getPort());
        outputStream.writeInt(this.protocol);
    }

    public long getEventId() {
        return this.eventId;
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @NonNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NonNull
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @NonNull
    public int getProtocol() {
        return this.protocol;
    }

    public void setEventId(long eventId) {
        this.eventId = eventId;
    }

    public void setUsername(@NonNull String username) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        this.username = username;
    }

    public void setUuid(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        this.uuid = uuid;
    }

    public void setAddress(@NonNull InetSocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.address = address;
    }

    public void setProtocol(@NonNull int protocol) {
        this.protocol = protocol;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostConnectionPacket)) {
            return false;
        }
        PostConnectionPacket other = (PostConnectionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEventId() != other.getEventId()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        InetSocketAddress this$address = this.getAddress();
        InetSocketAddress other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        return this.getProtocol() == other.getProtocol();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PostConnectionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $eventId = this.getEventId();
        result = result * 59 + (int)($eventId >>> 32 ^ $eventId);
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        InetSocketAddress $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        result = result * 59 + this.getProtocol();
        return result;
    }

    public String toString() {
        return "PostConnectionPacket(eventId=" + this.getEventId() + ", username=" + this.getUsername() + ", uuid=" + this.getUuid() + ", address=" + this.getAddress() + ", protocol=" + this.getProtocol() + ")";
    }

    public PostConnectionPacket() {
    }

    public PostConnectionPacket(long eventId, @NonNull String username, @NonNull UUID uuid, @NonNull InetSocketAddress address, @NonNull int protocol) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.eventId = eventId;
        this.username = username;
        this.uuid = uuid;
        this.address = address;
        this.protocol = protocol;
    }

    public PostConnectionPacket(@NonNull String username, @NonNull UUID uuid, @NonNull InetSocketAddress address, @NonNull int protocol) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.username = username;
        this.uuid = uuid;
        this.address = address;
        this.protocol = protocol;
    }
}

