/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.bungeekeeper.packets.bungee;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import lombok.NonNull;
import me.nurio.bungeekeeper.packets.IdentityUtil;
import me.nurio.bungeekeeper.packets.Packet;

public class ServerChangePacket
implements Packet {
    public static final byte PACKET_ID = 23;
    private long eventId = IdentityUtil.timeBasedId();
    @NonNull
    private String serverName;

    @Override
    public byte getId() {
        return 23;
    }

    @Override
    public void read(DataInputStream inputStream) {
        this.serverName = inputStream.readUTF();
    }

    @Override
    public void write(DataOutputStream outputStream) {
        outputStream.writeByte(23);
        outputStream.writeUTF(this.serverName);
    }

    public long getEventId() {
        return this.eventId;
    }

    @NonNull
    public String getServerName() {
        return this.serverName;
    }

    public void setEventId(long eventId) {
        this.eventId = eventId;
    }

    public void setServerName(@NonNull String serverName) {
        if (serverName == null) {
            throw new NullPointerException("serverName is marked non-null but is null");
        }
        this.serverName = serverName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerChangePacket)) {
            return false;
        }
        ServerChangePacket other = (ServerChangePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEventId() != other.getEventId()) {
            return false;
        }
        String this$serverName = this.getServerName();
        String other$serverName = other.getServerName();
        return !(this$serverName == null ? other$serverName != null : !this$serverName.equals(other$serverName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerChangePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $eventId = this.getEventId();
        result = result * 59 + (int)($eventId >>> 32 ^ $eventId);
        String $serverName = this.getServerName();
        result = result * 59 + ($serverName == null ? 43 : $serverName.hashCode());
        return result;
    }

    public String toString() {
        return "ServerChangePacket(eventId=" + this.getEventId() + ", serverName=" + this.getServerName() + ")";
    }

    public ServerChangePacket() {
    }

    public ServerChangePacket(long eventId, @NonNull String serverName) {
        if (serverName == null) {
            throw new NullPointerException("serverName is marked non-null but is null");
        }
        this.eventId = eventId;
        this.serverName = serverName;
    }

    public ServerChangePacket(@NonNull String serverName) {
        if (serverName == null) {
            throw new NullPointerException("serverName is marked non-null but is null");
        }
        this.serverName = serverName;
    }
}

