/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.events;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.nurio.events.RegisteredEventListener;
import me.nurio.events.handler.Event;

class EventManagement {
    private static Map<Class<?>, List<RegisteredEventListener>> eventMap = new HashMap();

    EventManagement() {
    }

    protected static void registerEvent(RegisteredEventListener registeredEvent) {
        eventMap.putIfAbsent(registeredEvent.getEvent(), new ArrayList());
        EventManagement.getRegisteredEventListenersFor(registeredEvent.getEvent()).add(registeredEvent);
        System.out.println("[EventManager] The event handler '" + registeredEvent.getName() + "' was successful registered.");
    }

    protected static List<RegisteredEventListener> getEventListenersFor(Event event) {
        return EventManagement.getEventListenersFor(event.getClass());
    }

    protected static List<RegisteredEventListener> getEventListenersFor(Class<?> event) {
        return EventManagement.getEventListenersOrderedByPriorityFor(event);
    }

    protected static List<RegisteredEventListener> getEventListenersOrderedByPriorityFor(Event event) {
        return EventManagement.getEventListenersOrderedByPriorityFor(event.getClass());
    }

    protected static List<RegisteredEventListener> getEventListenersOrderedByPriorityFor(Class<?> event) {
        return EventManagement.getRegisteredEventListenersFor(event).stream().sorted(Comparator.comparing(RegisteredEventListener::getPriority)).collect(Collectors.toList());
    }

    protected static List<RegisteredEventListener> getRegisteredEventListenersFor(Event event) {
        return EventManagement.getRegisteredEventListenersFor(event.getClass());
    }

    protected static List<RegisteredEventListener> getRegisteredEventListenersFor(Class<?> event) {
        return eventMap.getOrDefault(event, new ArrayList());
    }
}

