/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.events;

import java.lang.reflect.Method;
import me.nurio.events.EventManager;
import me.nurio.events.EventReflection;
import me.nurio.events.handler.Event;
import me.nurio.events.handler.EventListener;
import me.nurio.events.handler.EventPriority;

public class RegisteredEventListener {
    private EventListener listener;
    private Method method;
    private Class<?> event;
    private EventPriority priority;
    private boolean ignoreCancelled;
    private String name;

    public RegisteredEventListener(EventListener listener, Method method) {
        this.listener = listener;
        this.method = method;
        this.name = method.getName();
        this.event = EventReflection.getEventFromMethod(method);
        this.priority = EventReflection.getEventPriorityFromMethod(method);
        this.ignoreCancelled = EventReflection.getIgnoreCancelledFromMethod(method);
    }

    public void invoke(Event event) {
        try {
            this.method.invoke((Object)this.listener, event);
            if (EventManager.isDebugLoggingEnabled()) {
                System.out.println("[EventManager] Launching '" + this.name + "' event.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("[EventManager] Error launching '" + this.name + "' event.", e);
        }
    }

    Class<?> getEvent() {
        return this.event;
    }

    public EventPriority getPriority() {
        return this.priority;
    }

    public boolean isIgnoreCancelled() {
        return this.ignoreCancelled;
    }

    public String getName() {
        return this.name;
    }
}

