/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.events;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import me.nurio.events.EventManager;
import me.nurio.events.RegisteredEventListener;
import me.nurio.events.handler.Event;

class EventManagement {
    @NonNull
    private final EventManager eventManager;
    private Map<Class<?>, List<RegisteredEventListener>> eventMap = new HashMap();

    protected void registerEvent(RegisteredEventListener registeredEvent) {
        this.eventMap.putIfAbsent(registeredEvent.getEvent(), new ArrayList());
        this.getRegisteredEventListenersFor(registeredEvent.getEvent()).add(registeredEvent);
        if (this.eventManager.isDebugLoggingEnabled()) {
            System.out.println("[EventManager] The event handler '" + registeredEvent.getName() + "' was successful registered.");
        }
    }

    protected List<RegisteredEventListener> getEventListenersFor(Event event) {
        return this.getEventListenersFor(event.getClass());
    }

    protected List<RegisteredEventListener> getEventListenersFor(Class<?> event) {
        return this.getEventListenersOrderedByPriorityFor(event);
    }

    protected List<RegisteredEventListener> getEventListenersOrderedByPriorityFor(Event event) {
        return this.getEventListenersOrderedByPriorityFor(event.getClass());
    }

    protected List<RegisteredEventListener> getEventListenersOrderedByPriorityFor(Class<?> event) {
        return this.getRegisteredEventListenersFor(event).stream().sorted(Comparator.comparing(RegisteredEventListener::getPriority)).collect(Collectors.toList());
    }

    protected List<RegisteredEventListener> getRegisteredEventListenersFor(Event event) {
        return this.getRegisteredEventListenersFor(event.getClass());
    }

    protected List<RegisteredEventListener> getRegisteredEventListenersFor(Class<?> event) {
        return this.eventMap.getOrDefault(event, new ArrayList());
    }

    public EventManagement(@NonNull EventManager eventManager) {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        this.eventManager = eventManager;
    }
}

