/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.events;

import java.lang.reflect.Method;
import java.util.List;
import me.nurio.events.EventManagement;
import me.nurio.events.EventReflection;
import me.nurio.events.RegisteredEventListener;
import me.nurio.events.handler.Event;
import me.nurio.events.handler.EventListener;

public class EventManager {
    private final EventManagement eventManagement = new EventManagement(this);
    private boolean debugLoggingEnabled;

    public <L extends EventListener> void registerEvents(L listener) {
        List<Method> eventListeners = EventReflection.getHandledMethodsFrom(listener.getClass());
        eventListeners.forEach(method -> this.eventManagement.registerEvent(new RegisteredEventListener(this, listener, (Method)method)));
    }

    public <E extends Event> void callEvent(E event) {
        this.eventManagement.getEventListenersFor(event).stream().filter(listener -> !event.isCancelled() || event.isCancelled() && listener.isIgnoreCancelled()).forEach(listener -> listener.invoke(event));
    }

    public void setDebugLoggingEnabled(boolean debugLoggingEnabled) {
        this.debugLoggingEnabled = debugLoggingEnabled;
    }

    public boolean isDebugLoggingEnabled() {
        return this.debugLoggingEnabled;
    }
}

