/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.events;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.nurio.events.exceptions.EventHandlerNotFoundException;
import me.nurio.events.handler.Event;
import me.nurio.events.handler.EventHandler;
import me.nurio.events.handler.EventPriority;

public class EventReflection {
    public static boolean isHandledMethod(Method method) {
        return method.getAnnotation(EventHandler.class) != null;
    }

    public static List<Method> getHandledMethodsFrom(Class<?> classListener) {
        return Arrays.stream(classListener.getMethods()).filter(EventReflection::isHandledMethod).collect(Collectors.toList());
    }

    public static Class<?> getEventFromMethod(Method method) {
        if (method.getParameterCount() != 1) {
            throw new EventHandlerNotFoundException("Handled method doesn't have a event parameter or have more than one.");
        }
        Class<?> parameter = method.getParameterTypes()[0];
        Class<?> superClass = parameter.getSuperclass();
        if (!superClass.equals(Event.class)) {
            throw new EventHandlerNotFoundException("Handled method event parameter aren't a valid event.");
        }
        try {
            return parameter;
        }
        catch (Exception er) {
            throw new EventHandlerNotFoundException("Unexpected error", er);
        }
    }

    public static EventPriority getEventPriorityFromMethod(Method method) {
        EventHandler handler = method.getAnnotation(EventHandler.class);
        return handler.priority();
    }

    public static boolean getIgnoreCancelledFromMethod(Method method) {
        EventHandler handler = method.getAnnotation(EventHandler.class);
        return handler.ignoreCancelled();
    }
}

