/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import me.nurio.events.EventManager;
import me.nurio.events.RegisteredEventHandler;
import me.nurio.events.exceptions.EventHandlerNotFoundException;
import me.nurio.events.handler.Event;

class EventManagement {
    @NonNull
    private final EventManager eventManager;
    private Map<Class<?>, List<RegisteredEventHandler>> eventMap = new HashMap();

    protected List<RegisteredEventHandler> getRegisteredEvents() {
        return this.eventMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected void registerEvent(RegisteredEventHandler eventHandler) {
        this.eventMap.putIfAbsent(eventHandler.getEvent(), new ArrayList());
        List<RegisteredEventHandler> registeredEventHandlers = this.getEventHandlerFor(eventHandler.getEvent());
        registeredEventHandlers.add(eventHandler);
        registeredEventHandlers.sort(Comparator.comparing(RegisteredEventHandler::getPriority));
        if (this.eventManager.isDebugLoggingEnabled()) {
            System.out.println("[EventManager] The event handler '" + eventHandler.getName() + "' was successful registered.");
        }
    }

    protected void unregisterEvent(RegisteredEventHandler registeredEvent) {
        List<RegisteredEventHandler> registeredEventListeners = this.getEventHandlerFor(registeredEvent.getEvent());
        if (!registeredEventListeners.contains(registeredEvent)) {
            throw new EventHandlerNotFoundException(String.format("Can not unregister '%s' event cause it's not registered yet.", registeredEvent.getName()));
        }
        registeredEventListeners.remove(registeredEvent);
        registeredEventListeners.sort(Comparator.comparing(RegisteredEventHandler::getPriority));
        if (this.eventManager.isDebugLoggingEnabled()) {
            System.out.println("[EventManager] The event handler '" + registeredEvent.getName() + "' was successful un-registered.");
        }
    }

    protected List<RegisteredEventHandler> getEventHandlerFor(Event event) {
        return this.getEventHandlerFor(event.getClass());
    }

    protected List<RegisteredEventHandler> getEventHandlerFor(Class<?> event) {
        return this.eventMap.getOrDefault(event, new ArrayList());
    }

    public EventManagement(@NonNull EventManager eventManager) {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        this.eventManager = eventManager;
    }
}

