/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.events;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import me.nurio.events.EventManagement;
import me.nurio.events.EventReflection;
import me.nurio.events.RegisteredEventHandler;
import me.nurio.events.handler.Event;
import me.nurio.events.handler.EventListener;

public class EventManager {
    private final EventManagement eventManagement = new EventManagement(this);
    private boolean debugLoggingEnabled;

    public List<EventListener> getRegisteredListeners() {
        return this.eventManagement.getRegisteredEvents().stream().map(RegisteredEventHandler::getListener).distinct().collect(Collectors.toList());
    }

    public <L extends EventListener> void registerEvents(L listener) {
        List<Method> eventHandlerMethods = EventReflection.getHandledMethodsFrom(listener.getClass());
        List<RegisteredEventHandler> eventHandlers = eventHandlerMethods.stream().map(method -> new RegisteredEventHandler(this, listener, (Method)method)).collect(Collectors.toList());
        eventHandlers.forEach(this.eventManagement::registerEvent);
    }

    public <L extends EventListener> void unregisterEvents(L listener) {
        List<RegisteredEventHandler> eventHandlers = this.eventManagement.getRegisteredEvents().stream().filter(registeredListener -> registeredListener.getListener().equals(listener)).collect(Collectors.toList());
        eventHandlers.forEach(this.eventManagement::unregisterEvent);
    }

    public <E extends Event> void callEvent(E event) {
        for (RegisteredEventHandler eventHandler : this.eventManagement.getEventHandlerFor(event)) {
            if (event.isCancelled() && !eventHandler.isIgnoreCancelled()) continue;
            eventHandler.invoke(event);
        }
    }

    public void setDebugLoggingEnabled(boolean debugLoggingEnabled) {
        this.debugLoggingEnabled = debugLoggingEnabled;
    }

    public boolean isDebugLoggingEnabled() {
        return this.debugLoggingEnabled;
    }
}

