/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.minecraft.worldareas.areas;

import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.World;

public class BlockArea {
    private final World world;
    private final Location start;
    private final Location end;

    public BlockArea(Location start, Location end) {
        if (start.getWorld().getUID() != end.getWorld().getUID()) {
            throw new RuntimeException("Could not create an area between two different worlds.");
        }
        this.world = start.getWorld();
        this.start = start;
        this.end = end;
    }

    public boolean isInside(Location location) {
        if (location.getWorld().getUID() != this.world.getUID()) {
            return false;
        }
        Function<Location, Integer>[] dimensions = this.dimensions(Location::getBlockY, Location::getBlockX, Location::getBlockZ);
        return this.isInsideArea(location, dimensions);
    }

    @SafeVarargs
    private Function<Location, Integer>[] dimensions(Function<Location, Integer> ... axis) {
        return axis;
    }

    @SafeVarargs
    private boolean isInsideArea(Location location, Function<Location, Integer> ... dimensions) {
        for (Function<Location, Integer> dimension : dimensions) {
            if (this.isInAxis(location, dimension)) continue;
            return false;
        }
        return true;
    }

    private boolean isInAxis(Location location, Function<Location, Integer> blockAxis) {
        boolean a = blockAxis.apply(location) >= blockAxis.apply(this.start) && blockAxis.apply(location) <= blockAxis.apply(this.end);
        boolean b = blockAxis.apply(location) <= blockAxis.apply(this.start) && blockAxis.apply(location) >= blockAxis.apply(this.end);
        return a || b;
    }

    public World getWorld() {
        return this.world;
    }

    public Location getStart() {
        return this.start;
    }

    public Location getEnd() {
        return this.end;
    }
}

