/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.minecraft.worldareas.configuration;

import java.io.File;
import me.nurio.bukkit.configuration.files.GrechConfig;
import me.nurio.minecraft.worldareas.GrechAreas;
import me.nurio.minecraft.worldareas.areas.BlockArea;
import me.nurio.minecraft.worldareas.areas.WorldArea;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;

public class ConfigSaver {
    public static void saveAll() {
        GrechAreas.getWorldAreaFactory().getAreas().stream().forEach(ConfigSaver::save);
    }

    public static File save(WorldArea worldArea) {
        Bukkit.getLogger().info("Saving world area: " + worldArea.getUuid());
        GrechConfig config = new GrechConfig(GrechAreas.getPlugin(), "areas" + File.separator + worldArea.getUuid());
        String name = worldArea.getName();
        config.set("name", (Object)name);
        String uuid = worldArea.getUuid().toString();
        config.set("uuid", (Object)uuid);
        config.set("areas", null);
        ConfigurationSection areasSection = config.getConfig().createSection("areas");
        for (BlockArea area : worldArea.getAreas()) {
            int areaId = areasSection.getKeys(false).size();
            Bukkit.getLogger().info("Saving BlockArea '" + uuid + "'@'" + areaId + "'...");
            ConfigurationSection section = areasSection.createSection("" + areaId);
            config.setLocation("areas." + areaId + ".start", area.getStart());
            config.setLocation("areas." + areaId + ".end", area.getEnd());
        }
        Bukkit.getLogger().info("Writing WorldArea '" + uuid + "' to disk...");
        config.save();
        return config.getConfigFile();
    }
}

