/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.minecraft.worldareas.areas;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import me.nurio.minecraft.worldareas.areas.BlockArea;
import me.nurio.minecraft.worldareas.areas.expands.WorldAreaBarrier;
import me.nurio.minecraft.worldareas.utils.AreaUtils;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class WorldArea
implements WorldAreaBarrier {
    @NotNull
    private String name;
    @NotNull
    private UUID uuid;
    @NotNull
    private BlockArea area;
    private final AtomicReference<Object> blocks = new AtomicReference();

    public boolean isInside(Location location) {
        return this.area.isInside(location);
    }

    public WorldArea(@NotNull String name, @NotNull UUID uuid, @NotNull BlockArea area) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (area == null) {
            throw new NullPointerException("area is marked non-null but is null");
        }
        this.name = name;
        this.uuid = uuid;
        this.area = area;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public BlockArea getArea() {
        return this.area;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Location> getBlocks() {
        Object value = this.blocks.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.blocks;
            synchronized (atomicReference) {
                value = this.blocks.get();
                if (value == null) {
                    List<Location> actualValue = AreaUtils.getBlocksBetween(this.area.getStart(), this.area.getEnd());
                    value = actualValue == null ? this.blocks : actualValue;
                    this.blocks.set(value);
                }
            }
        }
        return (List)(value == this.blocks ? null : value);
    }
}

