/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.minecraft.worldareas.areas;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.nurio.minecraft.worldareas.areas.WorldArea;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class WorldAreaFactory {
    private List<WorldArea> areas = new ArrayList<WorldArea>();

    public void addWorldArea(@NotNull WorldArea area) {
        this.areas.add(area);
    }

    @Nullable
    public WorldArea fromLocation(@NotNull Location location) {
        return this.areas.stream().filter(area -> area.isInside(location)).findAny().orElse(null);
    }

    public boolean isAnyWorldAreaAt(@NotNull Location location) {
        return this.areas.stream().anyMatch(area -> area.isInside(location));
    }

    public List<WorldArea> getAreas() {
        return this.areas;
    }
}

