/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.minecraft.worldareas.listeners;

import me.nurio.minecraft.worldareas.GrechAreas;
import me.nurio.minecraft.worldareas.areas.WorldArea;
import me.nurio.minecraft.worldareas.areas.WorldAreaFactory;
import me.nurio.minecraft.worldareas.events.PlayerJoinAreaEvent;
import me.nurio.minecraft.worldareas.events.PlayerLeaveAreaEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class PlayerMovementListener
implements Listener {
    private final WorldAreaFactory worldAreaFactory = GrechAreas.getWorldAreaFactory();

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlock() == event.getTo().getBlock()) {
            return;
        }
        Location location = event.getTo();
        WorldArea areaTo = this.worldAreaFactory.fromLocation(event.getTo());
        WorldArea areaFrom = this.worldAreaFactory.fromLocation(event.getFrom());
        if (areaTo == null && areaFrom == null) {
            return;
        }
        if (areaFrom != null && areaTo == areaFrom) {
            return;
        }
        if (areaTo == null) {
            this.leave(event.getPlayer(), location, areaFrom);
            return;
        }
        this.join(event.getPlayer(), location, areaTo);
    }

    private void join(Player player, Location location, WorldArea area) {
        PlayerJoinAreaEvent areaJoinEvent = new PlayerJoinAreaEvent(player, location, area);
        Bukkit.getPluginManager().callEvent((Event)areaJoinEvent);
    }

    private void leave(Player player, Location location, WorldArea area) {
        PlayerLeaveAreaEvent areaLeaveEvent = new PlayerLeaveAreaEvent(player, location, area);
        Bukkit.getPluginManager().callEvent((Event)areaLeaveEvent);
    }
}

