/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.minecraft.worldareas.areas;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import me.nurio.minecraft.worldareas.areas.BlockArea;
import me.nurio.minecraft.worldareas.areas.expands.WorldAreaBarrier;
import me.nurio.minecraft.worldareas.utils.AreaUtils;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class WorldArea
implements WorldAreaBarrier {
    @NotNull
    private String name;
    @NotNull
    private UUID uuid;
    @NotNull
    private List<BlockArea> areas;
    private final AtomicReference<Object> blocks = new AtomicReference();

    public boolean isInside(Location location) {
        for (BlockArea a : this.areas) {
            if (!a.isInside(location)) continue;
            return true;
        }
        return false;
    }

    public WorldArea(@NotNull String name, @NotNull UUID uuid, @NotNull List<BlockArea> areas) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (areas == null) {
            throw new NullPointerException("areas is marked non-null but is null");
        }
        this.name = name;
        this.uuid = uuid;
        this.areas = areas;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public List<BlockArea> getAreas() {
        return this.areas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Location> getBlocks() {
        Object value = this.blocks.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.blocks;
            synchronized (atomicReference) {
                value = this.blocks.get();
                if (value == null) {
                    List actualValue = this.areas.stream().map(area -> AreaUtils.getBlocksBetween(area.getStart(), area.getEnd())).flatMap(Collection::stream).toList();
                    value = actualValue == null ? this.blocks : actualValue;
                    this.blocks.set(value);
                }
            }
        }
        return (List)(value == this.blocks ? null : value);
    }
}

