/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.minecraft.worldareas.utils.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Location;
import org.bukkit.World;

public class BlocksBetweenOperation {
    private final Location start;
    private final Location end;

    public List<Location> getBlocksBetween() {
        World world = this.start.getWorld();
        ArrayList<Location> locations = new ArrayList<Location>();
        for (int y : this.getAxisRange(Location::getBlockY)) {
            for (int x : this.getAxisRange(Location::getBlockX)) {
                for (int z : this.getAxisRange(Location::getBlockZ)) {
                    locations.add(new Location(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
                }
            }
        }
        return locations;
    }

    private List<Integer> getAxisRange(Function<Location, Integer> axis) {
        int a = axis.apply(this.start);
        int b = axis.apply(this.end);
        return IntStream.range(Math.min(a, b), Math.max(a, b) + 1).boxed().collect(Collectors.toList());
    }

    public BlocksBetweenOperation(Location start, Location end) {
        this.start = start;
        this.end = end;
    }
}

