/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.microkernel.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import me.nurio.microkernel.loader.ModuleReflectionManager;
import me.nurio.microkernel.modules.IModule;
import me.nurio.microkernel.modules.KernelModule;
import me.nurio.microkernel.modules.ModuleYaml;
import org.apache.commons.io.IOUtils;

public class KernelClassLoader
extends URLClassLoader {
    private final Map<String, Class<?>> classes = new ConcurrentHashMap();
    private final ModuleReflectionManager moduleReflectionManager;
    private final ModuleYaml moduleYaml;
    private final File moduleFile;
    private final JarFile moduleJar;
    private final URL url;
    private final IModule module;

    public KernelClassLoader(ModuleReflectionManager moduleReflectionManager, File moduleFile, ModuleYaml moduleYaml, ClassLoader parent) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        super(new URL[]{moduleFile.toURI().toURL()}, parent);
        this.moduleReflectionManager = moduleReflectionManager;
        this.moduleYaml = moduleYaml;
        this.moduleFile = moduleFile;
        this.moduleJar = new JarFile(moduleFile);
        this.url = moduleFile.toURI().toURL();
        Class<? extends KernelModule> mainClass = this.getModuleMainClass(moduleYaml);
        this.module = mainClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private Class<? extends KernelModule> getModuleMainClass(ModuleYaml moduleYaml) {
        try {
            Class<?> jarClass = Class.forName(moduleYaml.getMain(), true, this);
            return jarClass.asSubclass(KernelModule.class);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Cannot find main class '" + moduleYaml.getMain() + "'", ex);
        }
        catch (ClassCastException ex) {
            throw new RuntimeException("Module main class '" + moduleYaml.getMain() + "' does not extend KernelModule", ex);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    protected Class<?> findClass(String name, boolean checkAllModules) throws ClassNotFoundException {
        if (this.classes.containsKey(name)) {
            return this.classes.get(name);
        }
        Class<?> clazz = this.findClassInJar(name);
        if (clazz == null && checkAllModules) {
            clazz = this.moduleReflectionManager.getClassByName(name);
        }
        if (clazz == null) {
            clazz = super.findClass(name);
        }
        if (clazz != null) {
            this.moduleReflectionManager.setClass(name, clazz);
        }
        this.classes.put(name, clazz);
        return clazz;
    }

    private Class<?> findClassInJar(String name) throws ClassNotFoundException {
        byte[] classBytes;
        String path = name.replace('.', '/').concat(".class");
        JarEntry entry = this.moduleJar.getJarEntry(path);
        if (entry == null) {
            return null;
        }
        try (InputStream is = this.moduleJar.getInputStream(entry);){
            classBytes = IOUtils.toByteArray(is);
        }
        catch (IOException ex) {
            throw new ClassNotFoundException(name, ex);
        }
        this.definePackage(name);
        CodeSigner[] signers = entry.getCodeSigners();
        CodeSource source = new CodeSource(this.url, signers);
        return this.defineClass(name, classBytes, 0, classBytes.length, source);
    }

    private void definePackage(String name) {
        boolean hasPackage;
        int lastDotPosition = name.lastIndexOf(46);
        boolean bl = hasPackage = lastDotPosition != -1;
        if (!hasPackage) {
            return;
        }
        String pkgName = name.substring(0, lastDotPosition);
        if (this.getDefinedPackage(pkgName) != null) {
            return;
        }
        try {
            this.definePackage(pkgName, null, null, null, null, null, null, null);
        }
        catch (IllegalArgumentException ex) {
            if (this.getDefinedPackage(pkgName) != null) {
                return;
            }
            throw new IllegalStateException("Cannot find package " + pkgName);
        }
    }

    public IModule getModule() {
        return this.module;
    }
}

