/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.microkernel.loader;

import java.util.ArrayList;
import java.util.List;
import me.nurio.events.EventManager;
import me.nurio.microkernel.loader.ModuleFileManager;
import me.nurio.microkernel.loader.ModuleLoader;
import me.nurio.microkernel.loader.ModuleReflectionManager;
import me.nurio.microkernel.modules.IModule;

public class ModuleManager {
    private final EventManager eventManager;
    private ModuleLoader moduleLoader;
    private ModuleFileManager moduleFileManager;
    private ModuleReflectionManager moduleReflectionManager;
    private List<IModule> loadedModules = new ArrayList<IModule>();

    public ModuleManager(EventManager eventManager) {
        this.eventManager = eventManager;
        this.moduleLoader = new ModuleLoader(eventManager);
        this.moduleFileManager = new ModuleFileManager();
        this.moduleReflectionManager = new ModuleReflectionManager(this.moduleFileManager);
    }

    public List<IModule> loadAll() {
        List<IModule> modules = this.moduleReflectionManager.getAllModules();
        for (IModule module : modules) {
            this.moduleLoader.loadModule(module);
            this.loadedModules.add(module);
        }
        return modules;
    }

    public void unloadAll() {
        for (IModule module : this.loadedModules) {
            this.moduleLoader.unloadModule(module);
            this.loadedModules.remove(module);
        }
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public ModuleFileManager getModuleFileManager() {
        return this.moduleFileManager;
    }

    public ModuleReflectionManager getModuleReflectionManager() {
        return this.moduleReflectionManager;
    }

    public List<IModule> getLoadedModules() {
        return this.loadedModules;
    }
}

