/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.microkernel.loader;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import me.nurio.microkernel.loader.KernelClassLoader;
import me.nurio.microkernel.loader.ModuleFileManager;
import me.nurio.microkernel.modules.IModule;
import me.nurio.microkernel.modules.ModuleYaml;
import org.apache.commons.lang3.StringUtils;

public class ModuleReflectionManager {
    private final ModuleFileManager moduleFileManager;
    private final Map<String, Class<?>> classes = new ConcurrentHashMap();
    private final List<KernelClassLoader> loaders = new CopyOnWriteArrayList<KernelClassLoader>();

    public List<IModule> getAllModules() {
        return this.moduleFileManager.getModulesJarFiles().stream().map(this::getModule).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public IModule getModule(File moduleFile) {
        ModuleYaml moduleYaml = this.moduleFileManager.getYamler().getModuleYaml(moduleFile);
        String mainClassPath = moduleYaml.getMain();
        if (StringUtils.isBlank(mainClassPath)) {
            return null;
        }
        KernelClassLoader classLoader = new KernelClassLoader(this, moduleFile, moduleYaml, this.getClass().getClassLoader());
        this.loaders.add(classLoader);
        return classLoader.getModule();
    }

    protected void setClass(String name, Class<?> clazz) {
        if (this.classes.containsKey(name)) {
            return;
        }
        this.classes.put(name, clazz);
    }

    protected Class<?> getClassByName(String name) {
        if (this.classes.containsKey(name)) {
            return this.classes.get(name);
        }
        for (KernelClassLoader loader : this.loaders) {
            try {
                return loader.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public ModuleReflectionManager(ModuleFileManager moduleFileManager) {
        this.moduleFileManager = moduleFileManager;
    }
}

