/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.microkernel.loader;

import java.io.File;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import me.nurio.microkernel.exceptions.InvalidModuleLoadException;
import me.nurio.microkernel.modules.ModuleYaml;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.representer.Representer;

public class ModuleYamlParser {
    private Yaml yamlLoader = new Yaml(new Constructor(ModuleYaml.class), new Representer(){
        {
            this.getPropertyUtils().setSkipMissingProperties(true);
            this.getPropertyUtils().setBeanAccess(BeanAccess.FIELD);
        }
    });

    public ModuleYaml getModuleYaml(File moduleJar) throws InvalidModuleLoadException {
        ModuleYaml moduleYaml;
        JarFile jarFile = new JarFile(moduleJar);
        try {
            JarEntry entry = jarFile.getJarEntry("module.yml");
            if (entry == null) {
                throw new InvalidModuleLoadException("Module doesn't have a module.yml");
            }
            InputStream inputStream = jarFile.getInputStream(entry);
            ModuleYaml moduleYaml2 = (ModuleYaml)this.yamlLoader.load(inputStream);
            if (StringUtils.isBlank(moduleYaml2.getMain())) {
                throw new InvalidModuleLoadException("Module main class is not specified at the module.yml");
            }
            moduleYaml = moduleYaml2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                throw new InvalidModuleLoadException(exception.getMessage());
            }
        }
        jarFile.close();
        return moduleYaml;
    }
}

