/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.minecraft.pinger.serializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import me.nurio.minecraft.pinger.serializers.RawJsonDeserializer;

public class MotdJsonDeserializer
extends RawJsonDeserializer {
    private JsonNode node;
    private ObjectMapper mapper;

    @Override
    public String deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        this.mapper = (ObjectMapper)parser.getCodec();
        String json = super.deserialize(parser, context);
        this.node = this.mapper.readTree(json);
        String motd = json.contains("\"text\":") ? this.deserializeExtended() : this.deserializeLegacy();
        return this.removeIllegalCharacters(motd);
    }

    public String deserializeLegacy() {
        String motd = this.node.toString();
        return motd.substring(1, motd.length() - 1);
    }

    public String deserializeExtended() {
        return String.join((CharSequence)"", this.node.findValuesAsText("text"));
    }

    private String removeIllegalCharacters(String text) {
        return text.replaceAll("(\u00c3\u201a\u00c2\u00a7\\w)", "").replaceAll("\n", " ").trim();
    }
}

