/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.minecraft.pinger;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import lombok.NonNull;
import me.nurio.minecraft.pinger.beans.MinecraftServerStatus;
import me.nurio.minecraft.pinger.beans.OnlineMinecraftServerStatus;

public class MinecraftServerConnection {
    private ObjectMapper mapper = new ObjectMapper(){
        {
            this.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        }
    };
    @NonNull
    private InetSocketAddress address;
    private int timeout = 1000;
    private Socket socket = new Socket();
    private OutputStream outputStream;
    private DataOutputStream dataOutputStream;
    private InputStream inputStream;
    private InputStreamReader inputStreamReader;
    private DataInputStream dataInputStream;

    private void connect() throws IOException {
        this.socket.setSoTimeout(this.timeout);
        this.socket.connect(this.address, this.timeout);
        this.outputStream = this.socket.getOutputStream();
        this.dataOutputStream = new DataOutputStream(this.outputStream);
        this.inputStream = this.socket.getInputStream();
        this.inputStreamReader = new InputStreamReader(this.inputStream);
        this.dataInputStream = new DataInputStream(this.inputStream);
    }

    private void disconnect() throws IOException {
        this.dataOutputStream.close();
        this.outputStream.close();
        this.inputStreamReader.close();
        this.inputStream.close();
        this.socket.close();
    }

    private String handshake() throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream handshake = new DataOutputStream(b);
        handshake.writeByte(0);
        this.writeInteger(handshake, 4);
        this.writeInteger(handshake, this.address.getHostString().length());
        handshake.writeBytes(this.address.getHostString());
        handshake.writeShort(this.address.getPort());
        this.writeInteger(handshake, 1);
        this.writeInteger(this.dataOutputStream, b.size());
        this.dataOutputStream.write(b.toByteArray());
        this.dataOutputStream.writeByte(1);
        this.dataOutputStream.writeByte(0);
        int size = this.readInteger();
        int id = this.readInteger();
        if (id == -1) {
            throw new IOException("Premature end of stream");
        }
        if (id != 0) {
            throw new IOException("Invalid packet id");
        }
        int length = this.readInteger();
        if (length == -1) {
            throw new IOException("Premature end of stream");
        }
        if (length == 0) {
            throw new IOException("Invalid string length");
        }
        byte[] in = new byte[length];
        this.dataInputStream.readFully(in);
        return new String(in);
    }

    public MinecraftServerStatus fetchData() throws IOException {
        this.connect();
        long start = System.currentTimeMillis();
        String json = this.handshake();
        long time = System.currentTimeMillis() - start;
        this.disconnect();
        OnlineMinecraftServerStatus response = (OnlineMinecraftServerStatus)this.mapper.readValue(json, OnlineMinecraftServerStatus.class);
        response.setPing(time);
        return response;
    }

    private int readInteger() throws IOException {
        byte k;
        int i = 0;
        int j = 0;
        do {
            k = this.dataInputStream.readByte();
            i |= (k & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((k & 0x80) == 128);
        return i;
    }

    private void writeInteger(DataOutputStream out, int paramInt) throws IOException {
        while (true) {
            if ((paramInt & 0xFFFFFF80) == 0) {
                out.writeByte(paramInt);
                return;
            }
            out.writeByte(paramInt & 0x7F | 0x80);
            paramInt >>>= 7;
        }
    }

    public MinecraftServerConnection(@NonNull InetSocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.address = address;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

