/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.minecraft.pinger.utils;

import java.net.InetSocketAddress;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;

public class SRVResolver {
    public static InetSocketAddress getSocketAddress(String domain) {
        return SRVResolver.getSocketAddress(SRVResolver.getHost(domain), SRVResolver.getPort(domain));
    }

    public static InetSocketAddress getSocketAddress(String domain, int port) {
        Record[] records = new Lookup("_minecraft._tcp." + domain, 33).run();
        if (records != null && records.length >= 1) {
            SRVRecord srv = (SRVRecord)records[0];
            String hostname = srv.getTarget().toString().replaceFirst("\\.$", "");
            return new InetSocketAddress(hostname, srv.getPort());
        }
        return new InetSocketAddress(domain, port);
    }

    private static String getHost(String serverAddress) {
        if (!serverAddress.contains(":")) {
            return serverAddress;
        }
        return serverAddress.split(":")[0];
    }

    private static int getPort(String serverAddress) {
        if (!serverAddress.contains(":")) {
            return 25565;
        }
        return Integer.parseInt(serverAddress.split(":")[1]);
    }
}

