/*
 * Decompiled with CFR 0.152.
 */
package me.nurio.nlibrary.bukkit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class NLConfig {
    private Plugin pmain;
    private String fname;
    private File folder;
    private FileConfiguration config;
    private File configFile;

    public NLConfig(String filename, Plugin instance) {
        if (!filename.endsWith(".yml")) {
            filename = filename + ".yml";
        }
        this.fname = filename;
        this.pmain = instance;
        this.folder = this.pmain.getDataFolder();
        this.config = null;
        this.configFile = null;
        this.reload();
    }

    public FileConfiguration getConfig() {
        if (this.config == null) {
            this.reload();
        }
        return this.config;
    }

    public void reload() {
        if (!this.folder.exists()) {
            try {
                if (!this.folder.mkdir()) {
                    System.err.println("Error creating plugin folder!");
                }
            }
            catch (Exception e) {
                System.err.println("Error creating plugin folder!");
                System.err.println(e.getMessage());
            }
        }
        this.configFile = new File(this.folder, this.fname);
        if (!this.configFile.exists()) {
            try {
                this.configFile.createNewFile();
            }
            catch (IOException e) {
                System.err.println("Error creating plugin config file!");
                System.err.println(e.getMessage());
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public void saveDefaultConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.pmain.getDataFolder(), this.fname);
        }
        if (!this.configFile.exists()) {
            this.pmain.saveResource(this.fname, false);
        }
    }

    public void save() {
        if (this.config == null || this.configFile == null) {
            return;
        }
        try {
            this.getConfig().save(this.configFile);
        }
        catch (IOException ex) {
            System.err.println("Could not save config to " + this.configFile.getName());
            System.err.println(ex.getMessage());
        }
    }

    public void set(String path, Object o) {
        this.getConfig().set(path, o);
    }

    public void setLocation(String path, Location l) {
        this.getConfig().set(path + ".w", (Object)l.getWorld().getName());
        this.getConfig().set(path + ".x", (Object)l.getX());
        this.getConfig().set(path + ".y", (Object)l.getY());
        this.getConfig().set(path + ".z", (Object)l.getZ());
        this.getConfig().set(path + ".yaw", (Object)Float.valueOf(l.getYaw()));
        this.getConfig().set(path + ".pitch", (Object)Float.valueOf(l.getPitch()));
        this.save();
    }

    public Location getLocation(String path) {
        World world = Bukkit.getWorld((String)this.getConfig().getString(path + ".w"));
        double x = this.getConfig().getDouble(path + ".x");
        double y = this.getConfig().getDouble(path + ".y");
        double z = this.getConfig().getDouble(path + ".z");
        float yaw = Float.parseFloat("" + this.getConfig().getDouble(path + ".yaw"));
        float pitch = Float.parseFloat("" + this.getConfig().getDouble(path + ".pitch"));
        return new Location(world, x, y, z, yaw, pitch);
    }

    public void setItem(String patch, ItemStack item) {
        boolean hasStoredEnchants;
        if (item == null) {
            this.getConfig().set(patch + ".id", (Object)"AIR");
            this.save();
            return;
        }
        String id = item.getType().name();
        int amount = item.getAmount();
        this.getConfig().set(patch + ".id", (Object)id);
        this.getConfig().set(patch + ".amount", (Object)amount);
        boolean hasMeta = item.hasItemMeta();
        String name = hasMeta ? item.getItemMeta().getDisplayName() : "";
        List lore = hasMeta ? item.getItemMeta().getLore() : new ArrayList();
        int damage = ((Damageable)item.getItemMeta()).getDamage();
        this.getConfig().set(patch + ".hasMeta", (Object)hasMeta);
        this.getConfig().set(patch + ".name", (Object)name);
        this.getConfig().set(patch + ".lore", lore);
        this.getConfig().set(patch + ".damage", (Object)damage);
        boolean hasEnchants = item.getEnchantments().size() != 0;
        ArrayList<String> enchants = new ArrayList<String>();
        if (hasEnchants) {
            for (Enchantment enchname : item.getEnchantments().keySet()) {
                enchants.add(enchname.getKey() + "," + item.getEnchantmentLevel(enchname));
            }
        }
        ArrayList<String> storedenchants = new ArrayList<String>();
        EnchantmentStorageMeta meta = item.getType() == Material.ENCHANTED_BOOK && hasMeta ? (EnchantmentStorageMeta)item.getItemMeta() : null;
        boolean bl = hasStoredEnchants = meta != null ? meta.hasStoredEnchants() : false;
        if (hasStoredEnchants) {
            for (Enchantment enchname : meta.getStoredEnchants().keySet()) {
                storedenchants.add(enchname.getKey() + "," + meta.getStoredEnchantLevel(enchname));
            }
        }
        this.getConfig().set(patch + ".hasEnchants", (Object)hasEnchants);
        this.getConfig().set(patch + ".hasStoredEnchants", (Object)hasStoredEnchants);
        if (hasEnchants) {
            this.getConfig().set(patch + ".enchants", enchants);
        }
        if (hasStoredEnchants) {
            this.getConfig().set(patch + ".storedenchants", storedenchants);
        }
        boolean isPotion = item.getType() == Material.POTION || item.getType() == Material.SPLASH_POTION || item.getType() == Material.LINGERING_POTION || item.getType() == Material.TIPPED_ARROW;
        PotionMeta pmeta = null;
        if (isPotion) {
            pmeta = (PotionMeta)item.getItemMeta();
            PotionData pa = pmeta.getBasePotionData();
            this.getConfig().set(patch + ".isPotion", (Object)isPotion);
            this.getConfig().set(patch + ".potion_type", (Object)pa.getType().name());
            this.getConfig().set(patch + ".potion_upgraded", (Object)pa.isUpgraded());
            this.getConfig().set(patch + ".potion_extended", (Object)pa.isExtended());
        }
        this.save();
    }

    public ItemStack getItem(String patch) {
        boolean isPotion;
        if (!this.getConfig().isSet(patch + ".id")) {
            return new ItemStack(Material.AIR);
        }
        String id = this.getConfig().getString(patch + ".id");
        if (id == null || id.isEmpty()) {
            return new ItemStack(Material.AIR);
        }
        int amount = this.getConfig().getInt(patch + ".amount");
        ItemStack item = new ItemStack(Material.getMaterial((String)id));
        item.setAmount(amount);
        boolean hasMeta = this.getConfig().getBoolean(patch + ".hasMeta");
        String name = hasMeta ? this.getConfig().getString(patch + ".name") : "";
        ArrayList lore = hasMeta ? (ArrayList)this.getConfig().getStringList(patch + ".lore") : new ArrayList();
        int damage = this.getConfig().getInt(patch + ".damage");
        if (hasMeta) {
            if (damage != 0) {
                Damageable ditem = (Damageable)item.getItemMeta();
                ditem.setDamage(damage);
                item.setItemMeta((ItemMeta)ditem);
            }
            ItemMeta im = item.getItemMeta();
            im.setDisplayName(name);
            if (lore.size() > 0) {
                im.setLore((List)lore);
            }
            item.setItemMeta(im);
        }
        boolean hasEnchants = this.getConfig().getBoolean(patch + ".hasEnchants");
        HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
        if (hasEnchants) {
            for (String map : this.getConfig().getStringList(patch + ".enchants")) {
                String[] data = map.split(",");
                enchants.put(Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)data[0])), Integer.parseInt(data[1]));
            }
        }
        boolean hasStoredEnchants = this.getConfig().getBoolean(patch + ".hasStoredEnchants");
        HashMap<Enchantment, Integer> storedenchants = new HashMap<Enchantment, Integer>();
        if (hasStoredEnchants) {
            for (Object map : this.getConfig().getStringList(patch + ".storedenchants")) {
                String[] data = ((String)map).split(",");
                storedenchants.put(Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)data[0])), Integer.parseInt(data[1]));
            }
        }
        if (item.getType() == Material.ENCHANTED_BOOK && hasStoredEnchants) {
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)item.getItemMeta();
            for (Map.Entry ench : storedenchants.entrySet()) {
                meta.addStoredEnchant((Enchantment)ench.getKey(), ((Integer)ench.getValue()).intValue(), true);
            }
            item.setItemMeta((ItemMeta)meta);
        }
        if (hasEnchants) {
            item.addUnsafeEnchantments(enchants);
        }
        if ((isPotion = this.getConfig().getBoolean(patch + ".isPotion")) && (item.getType() == Material.POTION || item.getType() == Material.SPLASH_POTION || item.getType() == Material.LINGERING_POTION || item.getType() == Material.TIPPED_ARROW)) {
            String namepotion = this.getConfig().getString(patch + ".potion_type");
            boolean extended = this.getConfig().getBoolean(patch + ".potion_extended");
            boolean upgraded = this.getConfig().getBoolean(patch + ".potion_upgraded");
            PotionMeta pmeta = (PotionMeta)item.getItemMeta();
            pmeta.setBasePotionData(new PotionData(PotionType.valueOf((String)namepotion), extended, upgraded));
            item.setItemMeta((ItemMeta)pmeta);
        }
        return item;
    }

    public void setInventory(String patch, Inventory inv) {
        for (int current = 0; inv.getSize() - 1 >= current; ++current) {
            ItemStack item;
            try {
                item = inv.getItem(current);
            }
            catch (Exception er) {
                item = null;
            }
            this.setItem(patch + ".slot" + current, item);
        }
    }

    public Inventory getInventory(String patch) {
        int slots = this.getConfig().getConfigurationSection(patch).getKeys(false).size() - 1;
        Inventory inv = Bukkit.createInventory(null, (int)(slots + 1));
        for (int current = 0; inv.getSize() - 1 >= current; ++current) {
            inv.setItem(current, this.getItem(patch + ".slot" + current));
        }
        return inv;
    }
}

