/*
 * Decompiled with CFR 0.152.
 */
package me.xxnurioxx.libs.bukkit.commandhandler;

import java.util.HashMap;
import me.xxnurioxx.libs.bukkit.MColor;
import me.xxnurioxx.libs.bukkit.commandhandler.CommandInterface;
import me.xxnurioxx.libs.messages.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandHandler
implements CommandExecutor {
    private String unknown_command_message_id;
    private String console_command_not_allowed;
    private HashMap<String, CommandInterface> commands = new HashMap();

    public CommandHandler(String unknown_command_message_id, String console_command_not_allowed) {
        this.unknown_command_message_id = unknown_command_message_id;
        this.console_command_not_allowed = console_command_not_allowed;
    }

    public void registerCommand(String name, CommandInterface cmd) {
        this.commands.put(name, cmd);
    }

    public void setDefaultCommand(CommandInterface cmd) {
        this.commands.put(" _default", cmd);
    }

    public boolean existsCommand(String name) {
        return this.commands.containsKey(name);
    }

    public CommandInterface getExecutor(String name) {
        return this.commands.get(name);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        CommandInterface executor = null;
        if (args.length == 0) {
            executor = this.getExecutor(" _default");
        } else {
            if (!this.existsCommand(args[0])) {
                MessageBuilder msgbuilder = new MessageBuilder(this.unknown_command_message_id);
                msgbuilder.registerVariable("argument", args[0]);
                msgbuilder.getMessageResult().forEach(line -> sender.sendMessage(MColor.col(line)));
                return true;
            }
            executor = this.getExecutor(args[0]);
        }
        if (!executor.allowConsole() && !(sender instanceof Player)) {
            MessageBuilder msgbuilder = new MessageBuilder(this.console_command_not_allowed);
            msgbuilder.registerVariable("argument", args[0]);
            msgbuilder.getMessageResult().forEach(line -> sender.sendMessage(MColor.col(line)));
            return true;
        }
        return executor.onCommand(sender, cmd, commandLabel, args);
    }
}

