/*
 * Decompiled with CFR 0.152.
 */
package me.xxnurioxx.libs.messages;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.bukkit.plugin.Plugin;

public class NLLogs {
    private static String log_prefix = "";

    public static void setPrefix(String prefix) {
        log_prefix = "[" + prefix + "] ";
    }

    public static void info(String line) {
        System.out.println(log_prefix + line);
    }

    public static void reportCrash(Plugin plugin, String note, Throwable trow) {
        NLLogs.info("[Crash] " + note + " " + trow.getMessage());
        try {
            String classname = trow.getStackTrace()[0].getClassName();
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
            String formatted = format.format(cal.getTime());
            String filename = "plugin-crash-" + classname + "-" + formatted;
            File file = new File(plugin.getDataFolder() + File.separator + "Crashes" + File.separator + filename + ".log");
            if (!file.exists()) {
                file.createNewFile();
            }
            String lines = "===============================================\n";
            lines = lines + note + "\n";
            lines = lines + "===============================================\n";
            lines = lines + trow.getMessage() + "\n";
            lines = lines + "===============================================\n";
            lines = lines + ExceptionUtils.getStackTrace((Throwable)trow) + "\n";
            lines = lines + "===============================================\n\n\n\n\n\n\n";
            BufferedWriter output = new BufferedWriter(new FileWriter(file.getAbsolutePath()));
            output.append(lines);
            ((Writer)output).close();
        }
        catch (Exception e) {
            NLLogs.info("Error saving crash to file.");
            e.printStackTrace();
        }
    }
}

